/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.chickens.ChickensMod;
import net.creeperhost.chickens.config.JsonConfig;
import net.creeperhost.chickens.data.ItemData;
import net.creeperhost.chickens.handler.ItemHolder;
import net.creeperhost.chickens.handler.SpawnType;
import net.creeperhost.chickens.registry.ChickensRegistry;
import net.creeperhost.chickens.registry.ChickensRegistryItem;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ConfigHandler {
    public static final File configDir = new File("config/chickens");
    public static final File ChickensMainFile = new File(configDir, "main_chickens.cfg");
    public static final File ChickensFile = new File(configDir, "chickens.json");
    public static Map<ChickensRegistryItem, ItemData> MAP = new HashMap<ChickensRegistryItem, ItemData>();
    private static JsonConfig config;
    public static ArrayList<String> ErrorList;
    public static int chickenEntityId;
    public static int spawnProbability;
    public static int minBroodSize;
    public static int maxBroodSize;
    public static float netherSpawnChanceMultiplier;
    public static boolean alwaysShowStats;

    public static void LoadConfigs(List<ChickensRegistryItem> allchickens) {
        ConfigHandler.loadChickens(allchickens);
    }

    public static void loadChickensFromFile(File fileIn, Collection<ChickensRegistryItem> allChickens) {
        config = new JsonConfig(fileIn);
        if (!fileIn.exists()) {
            config.Load();
            String comment = "_comment";
            config.getString(comment, "name", "Just a Reference to the old system naming. Changing does nothing.");
            config.getString(comment, "is_enabled", "Is chicken enabled?");
            config.getString(comment, "lay_item", "Item the chicken will Lay. Changing the qty will double that amount on each gain bonus. ");
            config.getFullJson().get(comment).getAsJsonObject().add("lay_item_example", (JsonElement)new ItemHolder(new ItemStack((ItemLike)Items.f_42417_), true).writeJsonObject(new JsonObject()));
            config.getString(comment, "drop_item", "Item the chicken will Lay. Changing the qty will double that amount on each gain bonus. ");
            config.getString(comment, "spawn_type", "Chicken spawn type, can be: " + String.join((CharSequence)",", SpawnType.names()));
            config.getString(comment, "parent_1", "First parent, empty if it cant be breed. modid:chickenid #example: chickens:waterchicken");
            config.getString(comment, "parent_2", "Second parent, empty if it cant be breed. ");
            for (ChickensRegistryItem chicken : allChickens) {
                String registryName = chicken.getRegistryName().toString();
                config.getString(registryName, "name", chicken.getEntityName());
                boolean enabled = config.getBoolean(registryName, "is_enabled", true);
                chicken.setEnabled(enabled);
                float layCoefficient = config.getFloat(registryName, "lay_coefficient", 1.0f, 0.01f, 100.0f);
                chicken.setLayCoefficient(layCoefficient);
                chicken.setLayItem(ConfigHandler.loadItemStack(config, registryName, chicken, "lay_item", chicken.getLayItemHolder().setSource(registryName)));
                chicken.setDropItem(ConfigHandler.loadItemStack(config, registryName, chicken, "drop_item", chicken.getDropItemHolder().setSource(registryName)));
                SpawnType spawnType = SpawnType.valueOf(config.getString(registryName, "spawn_type", chicken.getSpawnType().toString()));
                chicken.setSpawnType(spawnType);
                ChickensRegistry.register(chicken);
            }
            for (ChickensRegistryItem chicken : allChickens) {
                ChickensRegistryItem parent1 = ChickensRegistry.getByRegistryName(ConfigHandler.getChickenParent(config, "parent_1", allChickens, chicken, chicken.getParent1()));
                ChickensRegistryItem parent2 = ChickensRegistry.getByRegistryName(ConfigHandler.getChickenParent(config, "parent_2", allChickens, chicken, chicken.getParent2()));
                if (parent1 != null && parent2 != null) {
                    chicken.setParentsNew(parent1, parent2);
                    continue;
                }
                chicken.setNoParents();
            }
            if (ConfigHandler.config.hasChanged) {
                config.Save();
            }
        } else {
            JsonObject jsonObject = config.ReadFile();
            jsonObject.entrySet().forEach(stringJsonElementEntry -> {
                if (!((String)stringJsonElementEntry.getKey()).startsWith("_comment")) {
                    try {
                        String name = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("name").getAsString();
                        boolean enabled = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("is_enabled").getAsBoolean();
                        float layCoefficient = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("lay_coefficient").getAsFloat();
                        String stack = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonObject("lay_item").getAsJsonPrimitive("itemID").getAsString();
                        String nbt = "";
                        if (((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonObject("lay_item").has("nbt")) {
                            nbt = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonObject("lay_item").getAsJsonObject("nbt").toString();
                        }
                        String spawn_type = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("spawn_type").getAsString();
                        String parent1Name = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("parent_1").getAsString();
                        String parent2Name = ((JsonElement)stringJsonElementEntry.getValue()).getAsJsonObject().getAsJsonPrimitive("parent_2").getAsString();
                        ItemStack stack1 = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(stack)));
                        ChickensRegistryItem chickensRegistryItem = new ChickensRegistryItem(new ResourceLocation("chickens", name), name, new ResourceLocation("chickens", "textures/entity/" + name + ".png"), stack1, 0, 0);
                        SpawnType spawnType = SpawnType.valueOf(spawn_type);
                        MAP.put(chickensRegistryItem, new ItemData(stack, nbt));
                        ChickensRegistryItem parent1 = ChickensRegistry.getByRegistryName(parent1Name);
                        ChickensRegistryItem parent2 = ChickensRegistry.getByRegistryName(parent2Name);
                        if (parent1 != null && parent2 != null) {
                            chickensRegistryItem.setParentsNew(parent1, parent2);
                        }
                        chickensRegistryItem.setEnabled(enabled);
                        chickensRegistryItem.setLayCoefficient(layCoefficient);
                        chickensRegistryItem.setSpawnType(spawnType);
                        ChickensRegistry.register(chickensRegistryItem);
                    }
                    catch (Exception e) {
                        ChickensMod.LOGGER.error("Exception caused when loading chicken with name " + (String)stringJsonElementEntry.getKey(), (Throwable)e);
                    }
                }
            });
        }
    }

    public static void loadChickens(Collection<ChickensRegistryItem> allChickens) {
        ConfigHandler.loadChickensFromFile(ChickensFile, allChickens);
    }

    private static String getChickenParent(JsonConfig configuration, String propertyName, Collection<ChickensRegistryItem> allChickens, ChickensRegistryItem chicken, ChickensRegistryItem parent) {
        String Category2 = chicken.getRegistryName().toString();
        return configuration.getString(Category2, propertyName, parent != null ? parent.getRegistryName().toString() : "");
    }

    private static ItemHolder loadItemStack(JsonConfig configuration, String Category2, ChickensRegistryItem chicken, String prefix, ItemHolder defaultItemStack) {
        return configuration.getItemHolder(Category2, prefix, defaultItemStack);
    }

    static {
        ErrorList = new ArrayList();
        chickenEntityId = 30000;
        spawnProbability = 10;
        minBroodSize = 3;
        maxBroodSize = 5;
        netherSpawnChanceMultiplier = 1.0f;
        alwaysShowStats = false;
    }
}

